/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.mixin;

import java.util.function.BiPredicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2488;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2968;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import snownee.snow.CoreModule;
import snownee.snow.GameEvents;
import snownee.snow.Hooks;
import snownee.snow.ModUtil;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.client.SnowClientConfig;
import snownee.snow.entity.FallingSnowEntity;

@Mixin(value={class_2488.class})
public class ModSnowLayerBlock
extends class_2248
implements SnowVariant {
    private static final class_265[] SNOW_SHAPES_MAGIC = new class_265[]{class_259.method_1073(), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0)};
    @Shadow
    private static class_265[] field_11517;

    public ModSnowLayerBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    @Overwrite
    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        if (ModUtil.terraforged || !SnowCommonConfig.thinnerBoundingBox) {
            return field_11517[(Integer)state.method_11654((class_2769)class_2488.field_11518) - 1];
        }
        int layers = (Integer)state.method_11654((class_2769)class_2488.field_11518);
        if (layers == 8) {
            return class_259.method_1077();
        }
        return SNOW_SHAPES_MAGIC[layers - 1];
    }

    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (SnowCommonConfig.snowGravity) {
            worldIn.method_39279(pos, (class_2248)this, this.tickRate());
        }
    }

    @Overwrite
    public class_2680 method_9559(class_2680 stateIn, class_2350 facing, class_2680 facingState, class_1936 worldIn, class_2338 currentPos, class_2338 facingPos) {
        if (SnowCommonConfig.snowGravity) {
            worldIn.method_39279(currentPos, (class_2248)this, this.tickRate());
            return stateIn;
        }
        return super.method_9559(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Overwrite
    public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
        return Hooks.canSurvive(state, (class_1922)worldIn, pos, false);
    }

    protected int tickRate() {
        return 2;
    }

    public void method_9588(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 random) {
        this.checkFallable((class_1937)worldIn, pos, state);
    }

    @Overwrite
    public void method_9514(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 random) {
        if (ModUtil.shouldMelt((class_1937)worldIn, pos)) {
            class_2680 upState;
            int layers = (Integer)state.method_11654((class_2769)class_2488.field_11518);
            if (layers == 8 && (upState = worldIn.method_8320(pos.method_10084())).method_26204() instanceof class_2488) {
                return;
            }
            if (CoreModule.TILE_BLOCK.is(state)) {
                GameEvents.onDestroyedByPlayer((class_1937)worldIn, null, pos, state, worldIn.method_8321(pos));
            } else {
                ModSnowLayerBlock.method_9497((class_2680)state, (class_1937)worldIn, (class_2338)pos);
                worldIn.method_8650(pos, false);
            }
            return;
        }
        if (ModUtil.terraforged) {
            return;
        }
        if (!SnowCommonConfig.snowAccumulationDuringSnowfall && !SnowCommonConfig.snowAccumulationDuringSnowstorm) {
            return;
        }
        if (random.method_43048(8) > 0) {
            return;
        }
        int layers = (Integer)state.method_11654((class_2769)class_2488.field_11518);
        class_2338 height = worldIn.method_8598(class_2902.class_2903.field_13197, pos);
        if (layers == 8) {
            if (height.method_10264() - 1 != pos.method_10264()) {
                return;
            }
            class_2680 upState = worldIn.method_8320(pos.method_10084());
            if (upState.method_26204() instanceof class_2488) {
                return;
            }
        } else if (height.method_10264() != pos.method_10264()) {
            return;
        }
        class_1959 biome = (class_1959)worldIn.method_23753(pos).comp_349();
        boolean flag = false;
        if (worldIn.method_8419() && biome.method_33599(pos)) {
            if (SnowCommonConfig.snowAccumulationDuringSnowfall) {
                flag = true;
            } else if (SnowCommonConfig.snowAccumulationDuringSnowstorm && worldIn.method_8546()) {
                flag = true;
            }
        }
        if (flag && layers < SnowCommonConfig.snowAccumulationMaxLayers) {
            ModSnowLayerBlock.accumulate((class_1937)worldIn, pos, state, (w, p) -> (SnowCommonConfig.snowAccumulationMaxLayers > 8 || !(w.method_8320(p.method_10074()).method_26204() instanceof ModSnowLayerBlock)) && w.method_8314(class_1944.field_9282, p) < 10, true);
        } else if (!SnowCommonConfig.snowNeverMelt && SnowCommonConfig.snowNaturalMelt && !worldIn.method_8419()) {
            if (layers == 1) {
                if (SnowCommonConfig.snowAccumulationMaxLayers > 8 && worldIn.method_8320(pos.method_10074()).method_26204() instanceof ModSnowLayerBlock) {
                    worldIn.method_8501(pos, class_2246.field_10124.method_9564());
                }
            } else {
                ModSnowLayerBlock.accumulate((class_1937)worldIn, pos, state, (w, p) -> !(w.method_8320(p.method_10084()).method_26204() instanceof ModSnowLayerBlock), false);
            }
        }
    }

    private static void accumulate(class_1937 world, class_2338 pos, class_2680 centerState, BiPredicate<class_1936, class_2338> filter, boolean accumulate) {
        int i = (Integer)centerState.method_11654((class_2769)class_2488.field_11518);
        for (int j = 0; j < 8; ++j) {
            int k = j / 2;
            class_2350 direction = class_2350.method_10139((int)k);
            class_2338 pos2 = pos.method_10093(direction);
            if (j % 2 == 1) {
                pos2 = pos2.method_10093(class_2350.method_10139((int)(k + 1)));
            }
            if (!world.method_8477(pos2) || !filter.test((class_1936)world, pos2)) continue;
            class_2680 state = world.method_8320(pos2);
            class_2338 height = world.method_8598(class_2902.class_2903.field_13197, pos2);
            if (height.method_10264() != pos2.method_10264() || !class_2246.field_10477.method_9558(state, (class_4538)world, pos2)) continue;
            int l = state.method_26204() instanceof class_2488 ? (Integer)state.method_11654((class_2769)class_2488.field_11518) : 0;
            if (!(accumulate ? i > l : i < l)) continue;
            if (accumulate) {
                Hooks.placeLayersOn(world, pos2, 1, false, (class_1750)new class_2968(world, pos2, class_2350.field_11036, class_1799.field_8037, class_2350.field_11033), false);
            } else {
                world.method_8501(pos2, (class_2680)state.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(l - 1)));
            }
            return;
        }
        if (accumulate) {
            Hooks.placeLayersOn(world, pos, 1, false, (class_1750)new class_2968(world, pos, class_2350.field_11036, class_1799.field_8037, class_2350.field_11033), false);
        } else {
            world.method_8501(pos, (class_2680)centerState.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(i - 1)));
        }
    }

    protected boolean checkFallable(class_1937 worldIn, class_2338 pos, class_2680 state) {
        class_2338 posDown = pos.method_10074();
        if (Hooks.canFallThrough(worldIn.method_8320(posDown), worldIn, posDown)) {
            if (!worldIn.field_9236) {
                worldIn.method_8501(pos, this.getRaw(state, (class_1922)worldIn, pos));
                FallingSnowEntity entity = new FallingSnowEntity(worldIn, (double)pos.method_10263() + 0.5, (double)pos.method_10264() - 0.5, (double)pos.method_10260() + 0.5, (Integer)state.method_11654((class_2769)class_2488.field_11518));
                worldIn.method_8649((class_1297)entity);
            }
            return true;
        }
        return false;
    }

    @Overwrite
    public boolean method_9616(class_2680 state, class_1750 useContext) {
        int i = (Integer)state.method_11654((class_2769)class_2488.field_11518);
        if (useContext.method_8041().method_31574(class_2246.field_10477.method_8389()) && i < 8) {
            if (useContext.method_7717() && state.method_27852(class_2246.field_10477)) {
                return useContext.method_8038() == class_2350.field_11036;
            }
            return true;
        }
        return SnowCommonConfig.snowAlwaysReplaceable && (Integer)state.method_11654((class_2769)class_2488.field_11518) < 8 || i == 1;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 stateIn, class_1937 worldIn, class_2338 pos, class_5819 rand) {
        if (!SnowClientConfig.particleThroughLeaves || rand.method_43048(32) > 0) {
            return;
        }
        class_1297 entity = class_310.method_1551().method_1560();
        if (entity != null && entity.method_24515().method_10262((class_2382)pos) > 256.0) {
            return;
        }
        class_2680 stateDown = worldIn.method_8320(pos.method_10074());
        if (stateDown.method_26164(class_3481.field_15503)) {
            double d0 = (double)pos.method_10263() + rand.method_43058();
            double d1 = (double)pos.method_10264() - 0.05;
            double d2 = (double)pos.method_10260() + rand.method_43058();
            worldIn.method_8406((class_2394)class_2398.field_28013, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public class_2680 onShovel(class_2680 state, class_1937 world, class_2338 pos) {
        int layers = (Integer)state.method_11654((class_2769)class_2488.field_11518) - 1;
        if (layers > 0) {
            return (class_2680)state.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(layers));
        }
        return this.getRaw(state, (class_1922)world, pos);
    }

    public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        class_2680 state2;
        class_1750 context;
        class_2248 block;
        class_2680 stateDown;
        if (player.method_6047().method_7960() && player.method_6079().method_7960() && !((stateDown = worldIn.method_8320(pos.method_10074())).method_26204() instanceof class_2488) && !stateDown.method_28498((class_2769)class_2741.field_12512)) {
            class_2586 blockEntity;
            if (state.method_27852(class_2246.field_10477)) {
                worldIn.method_8652(pos, Hooks.copyProperties(state, CoreModule.TILE_BLOCK.defaultBlockState()), 48);
            }
            if ((blockEntity = worldIn.method_8321(pos)) instanceof SnowBlockEntity) {
                SnowBlockEntity snowTile = (SnowBlockEntity)blockEntity;
                if (CoreModule.TILE_BLOCK.is(state) && snowTile.getState().method_26215()) {
                    worldIn.method_8652(pos, Hooks.copyProperties(state, class_2246.field_10477.method_9564()), 48);
                } else {
                    boolean bl = snowTile.options.renderOverlay = !snowTile.options.renderOverlay;
                    if (worldIn.field_9236) {
                        worldIn.method_8413(pos, state, state, 11);
                    }
                }
            }
            return class_1269.field_5812;
        }
        if (state.method_27852(class_2246.field_10477) && (block = class_2248.method_9503((class_1792)(context = new class_1750(player, handIn, player.method_5998(handIn), hit)).method_8041().method_7909())) != null && block != class_2246.field_10124 && context.method_7717() && (state2 = block.method_9605(context)) != null && Hooks.canContainState(state2) && state2.method_26184((class_4538)worldIn, pos)) {
            if (!worldIn.field_9236) {
                worldIn.method_8652(pos, state2, 48);
                block.method_9567(worldIn, pos, state, (class_1309)player, context.method_8041());
                int i = (Integer)state.method_11654((class_2769)class_2488.field_11518);
                if (Hooks.placeLayersOn(worldIn, pos, i, false, context, true) && !player.method_7337()) {
                    context.method_8041().method_7934(1);
                }
            }
            return class_1269.field_5812;
        }
        return super.method_9534(state, worldIn, pos, player, handIn, hit);
    }

    @Overwrite
    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2680 blockstate = context.method_8045().method_8320(context.method_8037());
        if (blockstate.method_26204() instanceof class_2488) {
            int i = (Integer)blockstate.method_11654((class_2769)class_2488.field_11518);
            return (class_2680)blockstate.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        class_1799 stack = context.method_8041();
        class_2487 tag = class_1747.method_38072((class_1799)stack);
        if (tag != null && "snowrealmagic:snow".equals(tag.method_10558("id"))) {
            return CoreModule.TILE_BLOCK.defaultBlockState();
        }
        return this.method_9564();
    }

    public void method_9554(class_1937 worldIn, class_2680 state, class_2338 pos, class_1297 entityIn, float fallDistance) {
        if (SnowCommonConfig.snowReduceFallDamage) {
            if (!state.method_27852((class_2248)this)) {
                return;
            }
            if (state.method_27852(class_2246.field_10477) || CoreModule.TILE_BLOCK.is(state)) {
                entityIn.method_5747(fallDistance, 0.2f, class_1282.field_5868);
                return;
            }
            state = worldIn.method_8320(pos);
            entityIn.method_5747(fallDistance, 1.0f - (float)((Integer)state.method_11654((class_2769)class_2488.field_11518)).intValue() * 0.1f, class_1282.field_5868);
            return;
        }
        super.method_9554(worldIn, state, pos, entityIn, fallDistance);
    }

    public void method_9591(class_1937 worldIn, class_2338 pos, class_2680 state, class_1297 entityIn) {
        double d0;
        if (!SnowCommonConfig.thinnerBoundingBox || !state.method_27852((class_2248)this)) {
            return;
        }
        int layers = (Integer)state.method_11654((class_2769)class_2488.field_11518) - 2;
        if (layers > 0 && (d0 = Math.abs(entityIn.method_18798().field_1351)) < 0.1 && !entityIn.method_21749()) {
            double d1 = 1.0f - (float)layers * 0.05f;
            entityIn.method_18799(entityIn.method_18798().method_18805(d1, 1.0, d1));
        }
    }

    @Override
    public double getYOffset() {
        return -1.0;
    }
}

